from mwrmab.run_algos import Experiment
import argparse

parser = argparse.ArgumentParser(description='Constant Costs Experiments')
parser.add_argument('--N', metavar='N', type=int,help='Number of arms')
parser.add_argument('--B', metavar='B', type=float, help='Budget per worker')
parser.add_argument('--M', metavar='M', type=int, default=3,help='Number of workers')
parser.add_argument('--minc', metavar='minc', type=float, default=1, help='Minimum cost')
parser.add_argument('--maxc', metavar='maxc', type=float, default=11, help='Maximum cost')
parser.add_argument('--epochs', metavar='epochs', type=int, default=50, help='Amount of epochs (samples with different random transition probabilities)')
parser.add_argument('--steps', metavar='steps', type=float, default=100, help='Steps in the planning horizon')
args = parser.parse_args()


N = args.N #number of arms
M = args.M #number of workers
B = args.B #budget
seed = 123

data='orderedWorkers'
EPOCHS=args.epochs
STEPS=args.steps
changeT = True

minC = args.minc
maxC = args.maxc

# Run Experiment
if N<=5:
    algos = ['MWRMAB', 'MWRMAB_bt', 'MWRMAB_adj', 'MWRMAB_adj_bt', 'OPT_fair','OPT','hawkins','S1S2','random','no_action']
else:
    algos = ['MWRMAB', 'MWRMAB_bt', 'MWRMAB_adj', 'MWRMAB_adj_bt','hawkins','S1S2','random','no_action']

exp = Experiment(N, M, B, minC=minC, maxC=maxC, seed=seed, data=data, EPOCHS=EPOCHS, STEPS=STEPS, changeT=changeT, algos=algos)
rewards, actions, usedBudget, runtime = exp.run()