from mwrmab.run_algos import Experiment
import argparse

parser = argparse.ArgumentParser(description='Constant Costs Experiments')
parser.add_argument('--N', metavar='N', type=int,help='Number of arms')
parser.add_argument('--B', metavar='B', type=float, help='Budget per worker')
parser.add_argument('--M', metavar='M', type=int, default=2,help='Number of workers')
parser.add_argument('--cost', metavar='cost', type=float, default=1, help='Cost per action (constant across actions and arms)')
parser.add_argument('--epochs', metavar='epochs', type=int, default=50, help='Amount of epochs (samples with different random transition probabilities)')
parser.add_argument('--steps', metavar='steps', type=float, default=100, help='Steps in the planning horizon')
args = parser.parse_args()

N = args.N #number of arms
M = args.M #number of workers
B = args.B #budget
seed = 123

data='constantCosts'
cost=args.cost
EPOCHS=args.epochs
STEPS=args.steps
changeT = True

# Run Experiment
if N<=5:
    algos = ['MWRMAB', 'MWRMAB_bt', 'MWRMAB_adj', 'MWRMAB_adj_bt', 'OPT_fair','OPT','hawkins','S1S2','random','no_action']
else:
    algos = ['MWRMAB', 'MWRMAB_bt', 'MWRMAB_adj', 'MWRMAB_adj_bt','hawkins','S1S2','random','no_action']

exp = Experiment(N, M, B, seed=seed, cost=cost, data=data, EPOCHS=EPOCHS, STEPS=STEPS, changeT=changeT,algos=algos)
rewards, actions, usedBudget, runtime = exp.run()