from mwrmab.run_algos import Experiment
import argparse

parser = argparse.ArgumentParser(description='Decoupled Counterexample Experiments')
parser.add_argument('--N', metavar='N', type=int,help='Number of arms')
parser.add_argument('--B', metavar='B', type=float, help='Budget per worker')
parser.add_argument('--cost', metavar='cost', type=float, default=1, help='Cost per action (constant across actions and arms)')
parser.add_argument('--epochs', metavar='epochs', type=int, default=50, help='Amount of epochs (samples with different random transition probabilities)')
parser.add_argument('--steps', metavar='steps', type=float, default=100, help='Steps in the planning horizon')
args = parser.parse_args()

N = args.N
B = args.B
seed = 123

data='decoupledCounterexample'
cost=1
EPOCHS=args.epochs
STEPS=args.steps
changeT = False

if N<=5:
    algos = ['MWRMAB', 'MWRMAB_bt', 'MWRMAB_adj', 'MWRMAB_adj_bt', 'OPT_fair','OPT','hawkins','S1S2','random','no_action']
else:
    algos = ['MWRMAB', 'MWRMAB_bt', 'MWRMAB_adj', 'MWRMAB_adj_bt','hawkins','S1S2','random','no_action']

# Run Experiment
exp = Experiment(N=N, B=B, seed=seed, cost=cost, data=data, EPOCHS=EPOCHS, STEPS=STEPS, changeT=changeT, algos=algos)
rewards, actions, usedBudget, runtime = exp.run()