from abc import ABC, abstractmethod
from typing import Tuple, Callable

from markovsbi.utils.prior_utils import Distribution


class Task(ABC):

    def __init__(self, name: str):
        self.name = name

    @property
    @abstractmethod
    def input_shape(self) -> Tuple[int, ...]:
        pass

    @property
    @abstractmethod
    def condition_shape(self) -> Tuple[int, ...]:
        pass

    @abstractmethod
    def get_prior(self) -> Distribution:
        pass

    @abstractmethod
    def get_simulator(self) -> Callable:
        pass

    def get_true_posterior(self, x_o) -> Distribution:
        raise NotImplementedError("This task does not have a true posterior.")
