# Vocabulary-defined Semantics (VDS)

## Code

- `utils/*`: the utility code files (adapted from KP)
- `vds.py`: the entry point to run experiments
- `vds_cfg.py`: for dynamic configurations
- `vds_finetune.py`: run the baselines (LoRA, IA3)
- `vds_load.py`: for loading data, benchmark, and metrics
- `vds_module.py`: the neural clustering module
- `vds_pipeline.py`: our approach
- `vds_shared.py`: for static configurations
- `vds_tmp.py`: compute the stats of data and models
- `vds_util.py`: the common utility functions
- `vds_vis.py`: draw tSNE visualizations
- `run_icl.py`: run the baselines (ICL)
- `run_kp.py`: run the baselines (KP)

## How to reproduce

The access to a Slurm Cluster is suggested, do following steps:
1. install the environment using `conda.yml`, remember to activate the environment
2. run experiments using `src/*.sh`, remember to specify the task you want to run
3. modify the Slurm parameters in `src/*.job`, in case the hardware or configure differ

- `abla`: the ablation study of SC
- `ia3`: the baseline method IA3
- `icl`: the baseline method ICL
- `kp`: the baseline method KP
- `lora`: the baseline method LoRA
- `vds`: our clustering-based approach

---
