def make_prompt(dataset, dataset_name, mode, indices=None):
    if dataset_name == 'subj':  # B
        template_func = template_subj
    elif dataset_name == 'mr':  # B
        template_func = template_mr
    elif dataset_name == 'mrpc':  # B
        template_func = template_mrpc
    elif dataset_name == 'agnews':  # M
        template_func = template_agnews
    elif dataset_name == 'carer':  # M
        template_func = template_carer
    elif dataset_name == 'sst5':  # M
        template_func = template_sst5
    elif dataset_name == 'trec':  # M
        template_func = template_trec
    elif dataset_name == 'webss':  # M
        template_func = template_webss
    else:
        raise NotImplementedError

    if mode == 'inference':
        return template_func(dataset, None, mode)
    prompt = ''
    if mode == 'compose':  # inputs are different, list of examples instead of dataset class
        for ins in indices:
            prompt += template_func(ins, dataset.label2verb[ins['label']], 'train')
            prompt += '\n'
        return prompt
    for ins in dataset.data:
        prompt += template_func(ins, dataset.label2verb[ins['label']], mode)
        prompt += '\n'
    return prompt


def template_subj(ins, label, mode):
    if mode == 'train':
        return f"input: {ins['sentence']}\ntype: {label}\n"
    else:
        return f"input: {ins['sentence']}\ntype:"


def template_mr(ins, label, mode):
    if mode == 'train':
        return f"review: {ins['sentence']}\nsentiment: {label}\n"
    else:
        return f"review: {ins['sentence']}\nsentiment:"


def template_mrpc(ins, label, mode):
    if mode == 'train':
        return f"Premise: {ins['sentence_1']}\nHypothesis: {ins['sentence_2']}\nPrediction: {label}\n"
    else:
        return f"Premise: {ins['sentence_1']}\nHypothesis: {ins['sentence_2']}\nPrediction:"


def template_agnews(ins, label, mode):
    if mode == 'train':
        return f"Input: {ins['sentence']}\nType: {label}\n"
    else:
        return f"Input: {ins['sentence']}\nType:"


def template_carer(ins, label, mode):
    if mode == 'train':
        return f"message: {ins['sentence']}\nemotion: {label}\n"
    else:
        return f"message: {ins['sentence']}\nemotion:"


def template_sst5(ins, label, mode):
    if mode == 'train':
        return f"review: {ins['sentence']}\nsentiment: {label}\n"
    else:
        return f"review: {ins['sentence']}\nsentiment:"


def template_trec(ins, label, mode):
    if mode == 'train':
        return f"Question: {ins['sentence']}\nType: {label}\n"
    else:
        return f"Question: {ins['sentence']}\nType:"


def template_webss(ins, label, mode):
    if mode == 'train':
        return f"input: {ins['sentence']}\ntype: {label}\n"
    else:
        return f"input: {ins['sentence']}\ntype:"
