## Static and Sequential Malicious Attacks in the Context of Selective Forgetting

Environment requirements:
```
python==3.7.12
pytorch==1.12.1
matplotlib==3.3.2
higher==0.2.1
scipy==1.7.3
opencv==4.6.0  
pickleshare==0.7.5
```

Here is an example to run the command in the main directory to pre-train a model.
```
python pretrain.py -dataset=CIFAR10 -net=ResNet18 -epoch=20 -num_classes=10 -batchsize=128 -lr=0.01 -modname=model1
```
Below is a description of the command. More parameter settings can be found in `utils/parameters.py`.

- `dataset` Dataset
- `net` Model
- `epoch` Training epochs
- `num_classes` Number of classes in the dataset
- `batchsize` Training batch size
- `lr` Training learning rate
- `modname` Trained model name

Here is an example to run the command in the main directory to perform selective forgetting attacks.

```
python first_order.py -craftproj=craft -dataset=CIFAR10 -net=ResNet18 -modname=model1 -pretrained -atsetting=untargeted
```

Below is a description of the command. More parameter settings can be found in `utils/parameters.py`.

- `craftproj` Project name
- `dataset` Dataset
- `net` Model
- `modname` Trained model name
- `atsetting` Attack setting
- `pretrained` Using pre-trained model
