import argparse

def get_parameter():
    parser = argparse.ArgumentParser(description='selective forgetting attack')

    parser.add_argument('-device', default='cuda', type=str, help='cuda/cpu')
    parser.add_argument('-datadir', type=str, default="./data", help="data directory")
    parser.add_argument('-moddir', type=str, default="./models", help="model directory")
    parser.add_argument('-outdir', default='./outputs', type=str, help='output directory')
    parser.add_argument('-logdir', default='./logs', type=str, help='log director')
    parser.add_argument('-vicdir', default='./victims', type=str, help='victim director')
    parser.add_argument('-imgdir', default='./images', type=str, help='images directory')
    parser.add_argument('-resdir', default='./results', type=str, help='results directory')
    parser.add_argument('-modname', default='model', type=str, help='pretrained model name')
    parser.add_argument('-craftproj', default='craft', type=str, help='craft project')

    # training
    parser.add_argument('-pretrained', action='store_true', help='load pretrained models')
    parser.add_argument('-net', default='ResNet18', type=str, help='model architecture')
    parser.add_argument('-lr', default=0.01, type=float, help='initial learning rate')
    parser.add_argument('-opt', default='SGD', type=str, help='initial optimizer')
    parser.add_argument('-dataset', default='CIFAR10', type=str, help='craft dataset')
    parser.add_argument('-batchsize', default=128, type=int, help='batch size')
    parser.add_argument('-epoch', default=20, type=int, help='number of pre-training epochs')
    parser.add_argument('-num_classes', default=10, type=int, help='number of classes')
    parser.add_argument('-trainsize', default=0.4, type=float, help='training set size')
    parser.add_argument('-load', action='store_true', help='load dataset')

    # unlearning attack
    parser.add_argument('-seed', default=11, type=int, help='random seed')
    parser.add_argument('-eps', default=16, type=float, help='perturbation additive bound, in pixel counts out of 255')
    parser.add_argument('-npoison', default=-1, type=int, help='number of poisons to craft')
    parser.add_argument('-targetclass', default=-1, type=int, help='target class ID')
    parser.add_argument('-poisonclass', default=-1, type=int, help='poison class ID')
    parser.add_argument('-ytargetadv', default=-1, type=int, help='adversarial class ID')
    parser.add_argument('-targetids', default=[], type=int, nargs='+', help='target image IDs')
    parser.add_argument('-ntargets', default=5, type=int, help='number of targets')
    parser.add_argument('-craftrate', default=0.01, type=float, help='initial crafting rate')
    parser.add_argument('-ncraftstep', default=30, type=int, help='number of craft steps')

    parser.add_argument('-atsetting', default='targeted', type=str, help='attack setting')
    parser.add_argument('-theta', default=100, type=float, help='theta function')

    # first-order
    parser.add_argument('-tau', default=0.04, type=float, help='initial unlearning rate')

    # victim
    parser.add_argument('-threshold', default=1.0, type=float, help='probability threshold')

    return parser.parse_args()