import architectures.resnet50
import architectures.densenet121
import architectures.multimodal
import architectures.gru
import architectures.mlp
import architectures.bert
import warnings

def select(arch, opt):
    if 'resnet50' in arch:
        model = resnet50.Network(opt)
    if 'densenet121' in arch:
        model = densenet121.Network(opt)
    if 'gru' in arch:
        model = gru.Network(opt)
    if 'mlp' in arch:
        model = mlp.Network(opt)
    if not opt.multimodal and ('text' in opt.modality or 'bert' in arch.lower()):
        model = bert.BERTNetwork(opt)
    
    if opt.multimodal:
        return multimodal.MultiModalNetwork(opt, model, bert.BERTNetwork(opt))

    return model
