"""
The network architectures and weights are adapted and used from the great https://github.com/Cadene/pretrained-models.pytorch.
"""
import torch, torch.nn as nn, torch.nn.functional as F


"""============================================================="""
class Network(torch.nn.Module):
    def __init__(self, opt):
        super(Network, self).__init__()

        self.pars  = opt
        self.model = nn.Sequential([
            nn.Linear(opt.text_dim, 512),
            F.relu,
            nn.Linear(512, 256),
            F.relu,
            nn.Linear(256, opt.embed_dim)
        ])

        self.name = opt.arch

    def forward(self, x, **kwargs):
        x = self.model(x)
        no_avg_feat = enc_out = x

        if 'normalize' in self.pars.arch:
            x = torch.nn.functional.normalize(x, dim=-1)

        return x, (enc_out, no_avg_feat)