import numpy as np

"""================================================================================================="""
HAS_OPTIONS = True
OPTIONS = {"mode": ["mean", "max", "min"], "include_negative": [True, False]} ## TODO: add other options

class Metric():
    def __init__(self, k, **kwargs):
        self.k        = k
        self.exclusive = kwargs.get("exclusive", True)

        self.requires = ['nearest_features', 'target_labels']
        self.name     = 'e_recall@{}'.format(k)

        if not self.exclusive:
            self.mode = kwargs.get("mode", "max")
            self.include_negative = kwargs.get("include_negative", True)
            self.name += "(multi-label,mode={},include_negative={})".format(self.mode, self.include_negative)

    def __call__(self, target_labels, k_closest_classes, **kwargs):
        if self.exclusive:
            recall_at_k = np.sum([1 for target, recalled_predictions in zip(target_labels, k_closest_classes) if target in recalled_predictions[:self.k]])/len(target_labels)
        else:
            f = np.mean if self.mode == "mean" else np.min if self.mode == "min" else np.max
            if self.include_negative:
                recall_at_k = np.mean([f((t == y).mean(axis = -1)) for t,y in zip(target_labels, k_closest_classes)])
            else:
                recall_at_k = np.mean([f((t[t == 1] == y[..., t == 1]).mean(axis = -1)) for t,y in zip(target_labels, k_closest_classes)])
        return recall_at_k
