"""
The network architectures and weights are adapted and used from the great https://github.com/Cadene/pretrained-models.pytorch.
"""
import torch, torch.nn as nn, torch.nn.functional as F
import pretrainedmodels as ptm





"""============================================================="""
class Network(torch.nn.Module):
    def __init__(self, opt):
        super(Network, self).__init__()

        self.pars  = opt
        self.model = ptm.__dict__['densenet121'](num_classes=1000, pretrained='imagenet' if not opt.not_pretrained else None)

        self.name = opt.arch

        if 'frozen' in opt.arch:
            for module in filter(lambda m: type(m) == nn.BatchNorm2d, self.model.modules()):
                module.eval()
                module.train = lambda _: None

        self.enc_out_dim = self.model.last_linear.in_features
        self.model.last_linear = torch.nn.Linear(self.enc_out_dim, opt.embed_dim)

        self.out_adjust = None


    def forward(self, x, **kwargs):
        x = self.model.features(x)
        x = F.relu(x, inplace=True)
        no_avg_feat = x
        
        x = F.adaptive_avg_pool2d(x, (1,1))
        enc_out = x = x.view(x.size(0),-1)
        
        x = self.model.last_linear(x)
            # x = self.model(x)

        if 'normalize' in self.pars.arch:
            x = torch.nn.functional.normalize(x, dim=-1)
        if self.out_adjust and not self.train:
            x = self.out_adjust(x)

        return x, (enc_out, no_avg_feat)
