import datasets.mimic_cxr as mimic_cxr
import datasets.chexpert as chexpert
import datasets.mimiciii as mimiciii
import datasets.mscoco as mscoco 
import datasets.mmimdb as mmimdb
import datasets.label_sets as ls

dsets = {
    "MIMIC-CXR-JPG": mimic_cxr,
    "CheXpert": chexpert,
    "mimiciii": mimiciii,
    "mscoco": mscoco,
    "mmimdb": mmimdb
}

def select(dataset, opt, data_path):
    dset = dsets.get(dataset, None)
    if dset:
        if opt.modality not in dset.MODALITY:
            raise ValueError(
                "Selected modality {} not included in available modality list for {}. \n\
                    Available modality list: {}".format(
                    ",".join(opt.modality), dataset, ",".join(dset.MODALITY)
            ))
        return dset.Give(opt, ls.get_label_set(opt.dataset, opt.label_set), data_path)
    raise NotImplementedError('A dataset for {} is currently not implemented.\n\
                               Currently available are : MIMIC-CXR-JPG, CheXpert, mimiciii, mscoco, mmimdb!'.format(dataset))
