import sys
sys.path.append("/linkhome/rech/genini01/uvp29is/Code/metanal_v2/dida")
sys.path.append("/linkhome/rech/genini01/uvp29is/Code/metanal_v2/dataloader")
#########################################################################################

import torch
import hydra
import numpy as np
import pandas as pd
np.random.seed(42)

from tqdm import tqdm
from metalearn import Metafeatures
from omegaconf import DictConfig, OmegaConf

import torch.optim as optim

from dida_network import Net
from dataloader_train import DatasetOpenMLCC18, get_list_dataset, get_list_dataset_cc18
from torch.utils.data import DataLoader, sampler

torch.backends.cudnn.deterministic = True

def compute(dataloader):
    
    list_dataset_metafeatures = []
    for X, y in tqdm(dataloader):
        Xs, ys = X[0], y[0]

        for X_, y_ in zip(Xs, ys):

            list_dataset_metafeatures.append(pd.DataFrame(mfs).reset_index(drop=True))

    df_metafeatures = pd.concat(list_dataset_metafeatures).fillna(0)
    df_metafeatures["index"] = list(range(len(list_dataset_metafeatures)))
    df_metafeatures.set_index("index", inplace=True)
    df_metafeatures.to_csv("/linkhome/rech/genini01/uvp29is/Code/metanal_v2/checkpoints/metafeatures_handcrafted_cc18.csv")



@hydra.main(config_name="../config.yaml")
def main(cfg: DictConfig) -> None:
    print("Run with config: ", cfg)
    torch.manual_seed(cfg.training.seed)
    torch.cuda.manual_seed_all(cfg.training.seed)
    print("--------------------------------------------------------------------")
    training_params = cfg["training"]

    # Prepare dataloader
    list_X, list_y = get_list_dataset_cc18()
    dataTrain = DatasetOpenMLCC18(list_X=list_X, list_y=list_y,
                              npoints=training_params.dataloader.npoints,
                              seed=training_params.seed,
                              nb_sample_dataset=training_params.dataloader.nb_sample_dataset)
    sampler_ = sampler.BatchSampler(
        sampler.RandomSampler(dataTrain),
        batch_size=training_params["dataloader"]["batch_size"],
        drop_last=training_params["dataloader"]["drop_last"])
    dataloader = DataLoader(dataset=dataTrain,
                            num_workers=training_params["dataloader"]["num_workers"],
                            sampler=sampler_)

    compute(dataloader)

if __name__ == "__main__":
    main()
