import numpy as np
import pandas as pd

from metalearn import Metafeatures


def extract(X, y, list_columns):
    dtype = {"TARGETS": "CATEGORICAL"}
    X_dict = {}
    for c_i in range(X.shape[1]):
        X_dict["c_" + str(c_i)] = X[:, c_i]
        if np.unique(X[:, c_i]).shape[0] < 3:
            dtype["c_" + str(c_i)] = "CATEGORICAL"
        else:
            dtype["c_" + str(c_i)] = "NUMERIC"
    metafeatures = Metafeatures()
    mfs = metafeatures.compute(
                pd.DataFrame(X_dict),
                Y=pd.Series(y, name='TARGETS', dtype="category"),
                column_types=dtype,
                metafeature_ids=metafeatures.list_metafeatures(group="simple"),
                exclude=None,
                seed=0,
                timeout=60*2,
    )
    return np.nan_to_num(np.array([mfs[mtf]["value"] for mtf in list_columns]))
