import numpy as np
import os
import pandas as pd
from sklearn.model_selection import KFold
from Dataset import Dataset

from sklearn.preprocessing import MinMaxScaler


class UCI(Dataset):
    def __init__(self, folder_path='/linkhome/rech/genini01/uvp29is/Code/metanal/datasets/uci/data/uci',seed=0,split=None,folds=5):
        Dataset.__init__(self)
        np.random.seed(seed)
        self.trn_data           = []
        self.trn_labels         = []
        self.tst_data   = []
        self.tst_labels = []

        folder_path='/linkhome/rech/genini01/uvp29is/Code/metanal/datasets/uci/data/uci'
        self.tst_names = np.load("/linkhome/rech/genini01/uvp29is/Code/metanal/metafeatures/batch_identification/UCI/results/test_list.npy")
        self.trn_names = np.load("/linkhome/rech/genini01/uvp29is/Code/metanal/metafeatures/batch_identification/UCI/results/train_list.npy")

        scaler = MinMaxScaler()

        for file in self.tst_names:
            data = np.asarray(pd.read_csv(os.path.join(folder_path,file,file+'_py.dat'),header=None))
            self.tst_data.append(data)
            self.tst_labels.append(np.asarray(pd.read_csv(os.path.join(folder_path,file,'labels_py.dat'),header=None)))

        for file in self.trn_names:
            data = np.asarray(pd.read_csv(os.path.join(folder_path,file,file+'_py.dat'),header=None))
            self.trn_data.append(data)
            self.trn_labels.append(np.asarray(pd.read_csv(os.path.join(folder_path,file,'labels_py.dat'),header=None)))
