import torch
import torch.nn as nn
import torch.nn.functional as F



class Handcrafted(nn.Module):
    def __init__(self, fc_metafeatures, dropout_fc):
        super(Handcrafted, self).__init__()
        self.list_module = torch.nn.ModuleList()

        self.list_fc = torch.nn.ModuleList()
        self.list_bn_fc = torch.nn.ModuleList()
        self.list_dropout_fc = torch.nn.ModuleList()

        for i, dim in enumerate(fc_metafeatures):
            if i == 0:
                self.list_fc.append(nn.Linear(43, dim))
            else:
                self.list_fc.append(nn.Linear(fc_metafeatures[i-1], dim))
            self.list_bn_fc.append(nn.BatchNorm1d(dim))
            self.list_dropout_fc.append(nn.Dropout(dropout_fc[i]))

    def forward(self, z, _):
        # Fully Connected

        for i, layer in enumerate(self.list_fc):
            z = layer(z)

            if i != len(self.list_fc) - 1:
                z = self.list_bn_fc[i](z)
                z = F.relu(z)
                z = self.list_dropout_fc[i](z)

        return z
