import os, shutil, glob

def copytree(src, dst, symlinks=False, ignore=None):
    for item in os.listdir(src):
        s = os.path.join(src, item)
        d = os.path.join(dst, item)
        if os.path.isdir(s):
            shutil.copytree(s, d, symlinks, ignore)
        else:
            shutil.copy2(s, d)

def count_parameters(model):
    return sum(p.numel() for p in model.parameters() if p.requires_grad)

def inplace_change(filename, old_string, new_string):
    # Safely read the input filename using 'with'
    with open(filename) as f:
        s = f.read()
        if old_string not in s:
            print('"{old_string}" not found in {filename}.'.format(**locals()))
            return

    # Safely write the changed content, if found in the file
    with open(filename, 'w') as f:
        print('Changing "{old_string}" to "{new_string}" in {filename}'.format(**locals()))
        s = s.replace(old_string, new_string)
        f.write(s)


def dump_all_python_files(dest_path):
    src_path = "/linkhome/rech/genini01/uvp29is/Code/metanal_v2"
    dida_path = "/linkhome/rech/genini01/uvp29is/Code/metanal_v2/dida"
    dataloader_path = "/linkhome/rech/genini01/uvp29is/Code/metanal_v2/dataloader"
    model_path = "/linkhome/rech/genini01/uvp29is/Code/metanal_v2/models"
    config_path = "/linkhome/rech/genini01/uvp29is/Code/metanal_v2/configurations"

    dest_dida_path = os.path.join(dest_path, "dida")
    dest_dataloader_path = os.path.join(dest_path, "dataloader")
    dest_models_path = os.path.join(dest_path, "models")
    dest_configurations_path = os.path.join(dest_path, "configurations")

    for src_dir, dest_dir in zip([dida_path, dataloader_path, model_path, config_path, src_path],
                                    [dest_dida_path, dest_dataloader_path, dest_models_path, dest_configurations_path, dest_path]):
        try:
            os.mkdir(dest_dir)
        except: # Directory already exist for dest_path
            pass
        for f in glob.glob(os.path.join(src_dir, "*.py")):
            shutil.copy(f, dest_dir)
            inplace_change(f.replace(src_dir, dest_dir), "sys.path.append(\"" + src_path, "sys.path.append(\"" + dest_path)
