from typing import Any


class Visitor(object):
    def defaultVisit(self, node, *args, **kwargs):
        raise NotImplementedError

    def __getattr__(self, attr):
        if attr.startswith("visit"):
            return self.defaultVisit
        return self.__getattribute__(attr)

    def _visitAll(self, iterable, *args, **kwargs):
        def filter(x):
            return (x is not None) or None

        return [filter(x) and accept(x, self, *args, **kwargs) for x in iterable]


# Because of the magic way we add accept methods, mypy does not know they exist
# so this method is important for accept calls to typecheck
def accept(obj: Any, v: Visitor, *args, **kwargs):
    return obj._accept(v, *args, **kwargs)
