from typing import Any, Iterator, List, Optional


class VisitorPathError(ValueError):

    _path: List[Any]

    def __init__(self, path: List[Any], message: Optional[str] = None):
        super().__init__(message)

        self._path = path

    def push_parent_path(self, part: Any) -> None:
        self._path.append(part)

    @property
    def path(self) -> Iterator[Any]:
        return reversed(self._path)

    def get_message_str(self) -> str:
        return super().__str__()

    def path_string(self) -> str:
        return "->".join(map(str, self.path))

    def __str__(self):
        pstr = self.path_string()
        return f"[{pstr}]: {self.get_message_str()}"
