class EnableSchemaValidation:
    def __init__(self):
        pass

    def __enter__(self):
        from lale.settings import (
            disable_data_schema_validation,
            disable_hyperparams_schema_validation,
            set_disable_data_schema_validation,
            set_disable_hyperparams_schema_validation,
        )

        self.existing_data_schema_validation_flag = disable_data_schema_validation
        self.existing_hyperparams_schema_validation_flag = (
            disable_hyperparams_schema_validation
        )
        set_disable_data_schema_validation(False)
        set_disable_hyperparams_schema_validation(False)

    def __exit__(self, value, type, traceback):
        from lale.settings import (
            set_disable_data_schema_validation,
            set_disable_hyperparams_schema_validation,
        )

        set_disable_data_schema_validation(self.existing_data_schema_validation_flag)
        set_disable_hyperparams_schema_validation(
            self.existing_hyperparams_schema_validation_flag
        )
