import setup

from lale.grammar import Grammar
from lale.lib.lale import Hyperopt
from lale.pretty_print import to_string
from sklearn.metrics import accuracy_score

from lale.lib.sklearn import MinMaxScaler as MinMax
from lale.lib.sklearn import StandardScaler as Standard
from lale.lib.sklearn import Normalizer as Norm
from lale.lib.sklearn import RobustScaler as Robust

from lale.lib.sklearn import PCA
from lale.lib.sklearn import PolynomialFeatures as PolyF
from lale.lib.sklearn import Nystroem as Nys

from lale.lib.sklearn import GaussianNB
from lale.lib.sklearn import GradientBoostingClassifier
from lale.lib.sklearn import KNeighborsClassifier as KNN
from lale.lib.sklearn import RandomForestClassifier
from lale.lib.sklearn import ExtraTreesClassifier
from lale.lib.sklearn import QuadraticDiscriminantAnalysis as QDA
from lale.lib.sklearn import PassiveAggressiveClassifier
from lale.lib.sklearn import DecisionTreeClassifier
from lale.lib.sklearn import LogisticRegression as LR
from lale.lib.sklearn import SVC

from lale.lib.xgboost import XGBClassifier as XGB
from lale.lib.lightgbm import LGBMClassifier as LGBM
from lale.lib.lale import ConcatFeatures as Concat

from lale.lib.lale import NoOp

def lale_pipeline_trainer(data, args):

	planned_pipeline = Standard >>PolyF >> (LGBM | XGB)
       
	(X_train, y_train), (X_test, y_test) = data

	trainer = Hyperopt(algo="anneal",
	    estimator=planned_pipeline,
	    cv=args.cv,
	    max_evals=args.max_eval,
	    scoring='accuracy',
	    max_opt_time=args.max_opt_time)
	trained = trainer.fit(X_train, y_train)
	best_pipeline = trained.get_pipeline()
	y_hat = trained.predict(X_test)
	test_acc = str(accuracy_score(y_test, y_hat))
	trials = trained.summary()
	statuses = list(trials.iloc[:,4])
	stats = {
	    'evaluations': len(statuses),
	    'aborted': statuses.count('fail'),
	    'completed': statuses.count('ok')
	}

	results = {
	    'test_acc': str(accuracy_score(y_test, y_hat)),
	    'stats': stats,
	    'pipeline': to_string(best_pipeline, show_imports=False) }

	return results

setup.run_experiments('small_pipeline_hyperopt_anneal', lale_pipeline_trainer)  

