import setup

import autosklearn.classification
from sklearn.metrics import accuracy_score

def autosklearn_adaboost_trainer(data, args):
	(X_train, y_train), (X_test, y_test) = data

	automl = autosklearn.classification.AutoSklearnClassifier(
		time_left_for_this_task=args.max_opt_time,
		per_run_time_limit=args.max_eval_time,
		include_estimators = ['adaboost'],
		include_preprocessors=["no_preprocessing", ],
		resampling_strategy='cv',
		resampling_strategy_arguments={'folds': args.cv},
		n_jobs=args.n_jobs)
	automl.fit(X_train.copy(), y_train.copy())
	automl.refit(X_train.copy(), y_train.copy())
	y_hat = automl.predict(X_test)
	test_acc = str(accuracy_score(y_test, y_hat))

	results = {
	    'test_acc': str(accuracy_score(y_test, y_hat)),
	    'stats': automl.sprint_statistics(),
	    'model': automl.show_models() }
	return results

setup.run_experiments('autosklearn_adaboost_5', autosklearn_adaboost_trainer)

