import os
import json
import ast
from numpy import nan
import argparse
import numpy as np

experiments = ["small_pipeline_hyperopt", "small_pipeline_hyperopt_anneal", "small_pipeline_hyperopt_rand", "small_pipeline_hyperband", "small_pipeline_admm", "small_pipeline_admm_boba", "small_pipeline_admm_gprnd"]

parser = argparse.ArgumentParser()
parser.add_argument('--file_name',
    action='store',
    dest='out_file_name',
    default='results_small_pipeline.log',
    help='Output file name')

args = parser.parse_args()

def preprocess_log(f, remove_line = True):
    if remove_line:
        file_lines = f.readlines()
        new_content = []
        for line in file_lines:
            if line.startswith("                                        'base_estimator': "):
                pass
            else:
                new_content.append(line)
        return "\n".join(new_content)
    else:
        return f.read()


results_dataset_exp = {}
exp_names_row = ""
for exp_name in experiments:
    RESULT_DIR = os.path.join(".","logs", exp_name)
    exp_names_row +=(exp_name+",")
    test_accs = []
    for file_name in os.listdir(RESULT_DIR):
        print(file_name)
        f = open(os.path.join(RESULT_DIR, file_name))
        result = eval(preprocess_log(f))
        test_acc = result['results']['test_acc']
        test_accs.append(test_acc)
        completed_trials = result['results']['stats']['completed']
    test_accs = np.asarray(test_accs, dtype=np.float32)
    results_dataset_exp[str(exp_name)+'_test_acc'] = str(100*np.mean(test_accs)) + "("+str(100*np.std(test_accs))+")"
    results_dataset_exp[str(exp_name)+'_completed_trials'] = completed_trials

result_row = []
with open(args.out_file_name, "w") as out_file:
    out_file.write(exp_names_row)
    out_file.write("\n")
    for exp_key, exp_value in results_dataset_exp.items():
        if exp_key.endswith("test_acc"):
            result_row.append(exp_value) 
    row = ",".join(result_row)        
    out_file.write(row)
    out_file.write("\n")

