from lale.lib.sklearn import AdaBoostClassifier, DecisionTreeClassifier
from lale.lib.sklearn import MinMaxScaler as MinMax
from lale.lib.sklearn import StandardScaler as Standard
from lale.lib.sklearn import Normalizer as Norm
from lale.lib.sklearn import RobustScaler as Robust
from lale.lib.sklearn import QuantileTransformer as Quantile
import setup
from lale.lib.lale import Hyperopt
from lale.pretty_print import to_string
from sklearn.metrics import accuracy_score

def lale_pipeline_adaboost_trainer(data, args):

	(X_train, y_train), (X_test, y_test) = data

	pipeline = (MinMax | Standard | Norm| Robust | Quantile) >> AdaBoostClassifier(base_estimator=DecisionTreeClassifier())
	trainer = Hyperopt(
	    estimator=pipeline,
	    cv=args.cv,
	    max_evals=args.max_eval,
	    scoring='accuracy',
	    max_opt_time=args.max_opt_time,
	    max_eval_time=args.max_eval_time)
	trained = trainer.fit(X_train, y_train)
	y_hat = trained.predict(X_test)
	test_acc = str(accuracy_score(y_test, y_hat))

	results = {
	    'test_acc': str(accuracy_score(y_test, y_hat)),
	    'pipeline': to_string(trained.get_pipeline(), show_imports=False) }
	return results
setup.run_experiments('lale_pipeline_adaboost_10', lale_pipeline_adaboost_trainer)
