import argparse
from datetime import datetime
from pprint import pprint
import os
from lale.datasets.openml.openml_datasets import fetch, experiments_dict
from pathlib import Path

datasets = [
    'Australian', 
    'blood-transfusion-service-center', 
    'spectf', 
    'breast-cancer',
    'diabetes', 
    'credit-g', 
    'hill-valley' ,
    'car', 
    'kc1', 
    'kr-vs-kp', 
    'shuttle', 
    'sylvine', 
    'phoneme', 
    'mfeat-factors',
    'jungle_chess_2pcs_raw_endgame_complete' ]

parser = argparse.ArgumentParser(description='Run auto-sklearn experiment.')
parser.add_argument('--dataset',
    action='store',
    dest='dataset',
    help='Datasetname')

parser.add_argument('--max-eval',
    action='store',
    dest='max_eval',
    type=int,
    default=10000,
    help='Maximum number of trials')
parser.add_argument('--cv',
    action='store',
    dest='cv',
    type=int,
    default=5,
    help='Number of folds for cross-validation')
parser.add_argument('--max-opt-time',
    action='store',
    dest='max_opt_time',
    type=int,
    default=3600,
    help='Timeout in seconds')
parser.add_argument('--max-eval-time',
    action='store',
    dest='max_eval_time',
    type=int,
    default=360,
    help='Timeout in seconds')
parser.add_argument('--max-depth',
    action='store',
    dest='max_depth',
    type=int,
    default=3,
    help='Maximal unfolding depth (Grammar)')
parser.add_argument('--n_jobs',
    action='store',
    dest='n_jobs',
    type=int,
    default=1,
    help='Number of jobs')
    
def parse_args():
    return parser.parse_args()

def get_openml_data(args):
    return fetch(args.dataset, 'classification')
        
def dump(exp_name, dataset, args, results):
    now = datetime.now().strftime("%Y_%m_%d_%H_%M_%S")
    dirname = f"logs/{exp_name}"
    Path(dirname).mkdir(parents=True, exist_ok=True)
    filename = os.path.join(dirname, dataset + f"_{exp_name}_" + now + '.log')
    summary = {
        'dataset': dataset,
        'args': {arg: getattr(args, arg) for arg in vars(args)},
        'results': results }
    with open(filename, 'w') as file:
        pprint(summary, file)
        
def run_experiments(exp_name, trainer):
    args = parse_args()
    for dataset in datasets:
        print('XXXXX Processing dataset', dataset, 'XXXXX')
        data = fetch(dataset, 'classification')
        results = trainer(data, args)
        dump(exp_name, dataset, args, results)
