import pandas as pd
from scipy import stats
import numpy as np
from collections import defaultdict
import time, math

data = pd.read_csv("user_study_aggregated_anonymized_summary.csv")

def converttimestr(x):
    if not isinstance(x, str) and math.isnan(x):
        return x
    s = str(x).split(":")
    total_seconds = int(s[1]) * 60 + int(s[2])
    return total_seconds


data["Total Time"] = data["Total Time"].apply(converttimestr)
#print(data["Total Time"])

lale = data[data["Task"]=="lale"]
sklearn = data[data["Task"]=="scikit-learn"]

lale["Task 4 lines of code"] = lale["Task 4 lines of code"].apply(pd.to_numeric, errors='coerce')
sklearn["Task 4 lines of code"] = sklearn["Task 4 lines of code"].apply(pd.to_numeric, errors='coerce')
#print(lale["Task 4 lines of code"])
#print(sklearn["Task 4 lines of code"])

loc_t = stats.ttest_ind(lale["Task 4 lines of code"], sklearn["Task 4 lines of code"], nan_policy='omit')
loc_w = stats.mannwhitneyu(lale["Task 4 lines of code"], sklearn["Task 4 lines of code"].dropna())
print("LOC")
print(loc_t)
print(loc_w)

t1_dict = defaultdict(int)
t1_dict["yes"] = 1
lale_t1 = lale["Task 1 correct?"].map(t1_dict)
sklearn_t1 = sklearn["Task 1 correct?"].map(t1_dict)
print(lale_t1)
print(sklearn_t1)
t1_table = np.array([[8,5],[1,4]])
t1_fisher = stats.fisher_exact(t1_table, alternative="greater")

t1_t = stats.ttest_ind(lale_t1, sklearn_t1)
t1_w = stats.wilcoxon(lale_t1, sklearn_t1)
print("T1")
print(t1_t)
print(t1_w)
print(t1_fisher)

lale_t4 = [1, 1, 1, 1, 1, 1, 1, 1, 1]
sklearn_t4 = [0, 1, 0, 1, 1, 1, 1, 1, 1]
t4_t = stats.ttest_ind(lale_t4, sklearn_t4)
t4_w = stats.wilcoxon(lale_t4, sklearn_t4)
print("T4")
print(t4_t)
print(t4_w)

#print(lale["Total Time"])
#print(sklearn["Total Time"])
time_t = stats.ttest_ind(lale["Total Time"], sklearn["Total Time"], nan_policy="omit")
time_w = stats.mannwhitneyu(lale["Total Time"].dropna(), sklearn["Total Time"])
print("Time")
print(time_t)
print(time_w)

lale_bs = pd.DataFrame(lale)
sklearn_bs = pd.DataFrame(sklearn)
for _ in range(91):
    lale_bs = pd.concat([lale_bs, lale.sample(1, replace=True)])
    sklearn_bs = pd.concat([sklearn_bs, sklearn.sample(1, replace=True)])

print(len(lale_bs))
print(len(sklearn_bs))

loc_t = stats.ttest_ind(lale_bs["Task 4 lines of code"], sklearn_bs["Task 4 lines of code"], nan_policy='omit')
loc_w = stats.mannwhitneyu(lale_bs["Task 4 lines of code"], sklearn_bs["Task 4 lines of code"].dropna())
print("LOC BS")
print(loc_t)
print(loc_w)

t1_dict = defaultdict(int)
t1_dict["yes"] = 1
lale_t1 = lale_bs["Task 1 correct?"].map(t1_dict)
sklearn_t1 = sklearn_bs["Task 1 correct?"].map(t1_dict)
t1_table = np.array([[8,5],[1,4]])
t1_fisher = stats.fisher_exact(t1_table, alternative="greater")

t1_t = stats.ttest_ind(lale_t1, sklearn_t1)
t1_w = stats.wilcoxon(lale_t1, sklearn_t1)
print("T1 BS")
print(t1_t)
print(t1_w)
#print(t1_fisher)

def t4_task(x):
    if x == "(didn't finish)" or x == "for loop (but incorrect)":
        return 0
    return 1
lale_t4 = lale_bs["Task 4 approach"].map(t4_task)
sklearn_t4 = sklearn_bs["Task 4 approach"].map(t4_task)
t4_t = stats.ttest_ind(lale_t4, sklearn_t4)
t4_w = stats.wilcoxon(lale_t4, sklearn_t4)
print("T4 BS")
print(t4_t)
print(t4_w)

#print(lale["Total Time"])
#print(sklearn["Total Time"])
time_t = stats.ttest_ind(lale_bs["Total Time"], sklearn_bs["Total Time"], nan_policy="omit")
time_w = stats.mannwhitneyu(lale_bs["Total Time"].dropna(), sklearn_bs["Total Time"])
print("Time BS")
print(time_t)
print(time_w)
