# Lale

[![License](https://img.shields.io/badge/License-Apache%202.0-blue.svg)](https://opensource.org/licenses/Apache-2.0)
<br />

Lale is a Python library for semi-automated data science.
Lale makes it easy to automatically select algorithms and tune
hyperparameters of pipelines that are compatible with
[scikit-learn](https://scikit-learn.org), in a type-safe fashion.  If
you are a data scientist who wants to experiment with automated
machine learning, this library is for you!
Lale adds value beyond scikit-learn along three dimensions:
automation, correctness checks, and interoperability.
For *automation*, Lale provides a consistent high-level interface to
existing pipeline search tools including Hyperopt, GridSearchCV, and SMAC.
For *correctness checks*, Lale uses JSON Schema to catch mistakes when
there is a mismatch between hyperparameters and their type, or between
data and operators.
And for *interoperability*, Lale has a growing library of transformers
and estimators from popular libraries such as scikit-learn, XGBoost,
PyTorch etc.
Lale can be installed just like any other Python package and can be
edited with off-the-shelf Python tools such as Jupyter notebooks.

The name Lale, pronounced *laleh*, comes from the Persian word for
tulip. Similarly to popular machine-learning libraries such as
scikit-learn, Lale is also just a Python library, not a new stand-alone
programming language. It does not require users to install new tools
nor learn new syntax.

Lale is distributed under the terms of the Apache 2.0 License, see
[LICENSE.txt].
It is currently in an **Alpha release**, without warranties of any
kind.

Installing from Source
----------------------

Install lale from the current directory:


    pip install .[full]

Now, you are ready to run some tests. For a quick check, do the
following in the ``lale`` directory:


    export PYTHONPATH=`pwd`
    python -m unittest test.test_core_classifiers.TestLogisticRegression

The output should look like::

    Ran 12 tests in 0.931s
    OK
