## Independent Component Alignment for Multi-task Learning
Official implementation of the paper "Independent Component Alignment for Multi-task Learning".

### Instruction for running our code:

[Warn] We tried to exclude the most of randomness from the implementation. But according to pytorch documentation it is not possible to remove it completely. This is the reason that results may slightly differ from ones stated in the paper.

```
export PYTHONPATH=$PYTHONPATH:./aligned-multi-task-learning
cd ./aligned-multi-task-learning
```
# run teaser
```
python code/tools/teaser.py
```

# run multi-mnist training
1. Run the training by specifying a data destitantion path $MMNIST_DATA_PATH and the balancer $BALANCER (`zalign, talign, mgda, mgdaub, gradnorm, uncertainty, pcgrad`). The dataset will be downloaded automatically.
```
python code/tools/train_mnist.py --data_path=$MMNIST_DATA_PATH --balancer=$BALANCER
```

# run celeba training
1. Download the CelebA dataset from [here](https://mmlab.ie.cuhk.edu.hk/projects/CelebA.html) and move it to $CELEBA_DATA_PATH.
2. Run the training by specifying the balancer $BALANCER (`zalign, talign, mgda, mgdaub, gradnorm, uncertainty, pcgrad`):
```
python code/tools/train_celeba.py --data_path=$CELEBA_DATA_PATH --balancer=$BALANCER
```

# run cityscapes training
1. Download the CityScapes dataset from [here](https://www.cityscapes-dataset.com) with disparity data included and move it to $CITYSCAPES_DATA_PATH.
2. Run the training by specifying the balancer $BALANCER (`zalign, talign, mgda, mgdaub, gradnorm, uncertainty, pcgrad`):
```
python code/tools/train_cityscapes.py --data_path=$CITYSCAPES_DATA_PATH --balancer=$BALANCER
```

# run relocalization training
1. Download the 7Scenes dataset from [here](https://www.microsoft.com/en-us/research/project/rgb-d-dataset-7-scenes/) and move it to $SEVEN_SCENES_DATA_PATH
2. Resize all the images such that the smaller dimension is 256 and the aspect ratio is intact using the following command:
```
cd $SEVEN_SCENES_DATA_PATH
find . -name "*.color*png" | xargs -I {} convert {} -resize "256^>" {}
```
3. Run the training by specifying the scene name $SCENE_NAME (`chess, fire, stairs, office, heads, pumpkin, redkitchen`) and the balancer $BALANCER (`zalign, talign, mgda, mgdaub, gradnorm, uncertainty, pcgrad`):
```
python code/tools/train_posenet.py --data_path=$SEVEN_SCENES_DATA_PATH --scene_name=$SCENE_NAME --balancer=$BALANCER
```
