import argparse
import numpy

import utils
# from utils import device


# Parse arguments

parser = argparse.ArgumentParser()
parser.add_argument("--env", required=True,
                    help="name of the environment to be run (REQUIRED)")
parser.add_argument("--model", required=True,
                    help="name of the trained model (REQUIRED)")
parser.add_argument("--seed", type=int, default=0,
                    help="random seed (default: 0)")
parser.add_argument("--shift", type=int, default=0,
                    help="number of times the environment is reset at the beginning (default: 0)")
parser.add_argument("--argmax", action="store_true", default=False,
                    help="select the action with highest probability (default: False)")
parser.add_argument("--pause", type=float, default=0.1,
                    help="pause duration between two consequent actions of the agent (default: 0.1)")
parser.add_argument("--gif", type=str, default=None,
                    help="store output as gif with the given filename")
parser.add_argument("--episodes", type=int, default=4,
                    help="number of episodes to visualize")
parser.add_argument("--memory", action="store_true", default=False,
                    help="add a LSTM to the model")
parser.add_argument("--text", action="store_true", default=False,
                    help="add a GRU to the model")

args = parser.parse_args()

# Set seed for all randomness sources

utils.seed(args.seed)

# Set device
import torch
device = torch.device("cuda:1" if torch.cuda.is_available() else "cpu")
print(f"Device: {device}\n")


# Load environment
import gym as gym

env = utils.make_env(args.env, args.seed, render_mode="human")
# env = make_env(args.env, 1, args.seed)
from minigrid.wrappers import ReseedWrapper
env = ReseedWrapper(env, seeds=[0,0], seed_idx=0)
for _ in range(args.shift):
    env.reset()
print("Environment loaded\n")

# Load agent

model_dir = utils.get_model_dir(args.model)
if ('rnd' in args.model) or ('TeCLE' in args.model):
    agent = utils.RNDAgent(env.observation_space, env.action_space, model_dir,
                        argmax=args.argmax, use_memory=args.memory, use_text=args.text)
else:
    agent = utils.Agent(env.observation_space, env.action_space, model_dir,
                        argmax=args.argmax, use_memory=args.memory, use_text=args.text)

print("Agent loaded\n")

# Run the agent

if args.gif:
    from array2gif import write_gif

    frames = []

# Create a window to view the environment
env.render()

for episode in range(args.episodes):
    obs, _ = env.reset()
    print(episode)
    while True:
        # print("a")
        env.render()
        if args.gif:
            frames.append(numpy.moveaxis(env.get_frame(), 2, 0))

        action = agent.get_action(obs)
        obs, reward, terminated, truncated, _ = env.step(action)
        done = terminated | truncated
        agent.analyze_feedback(reward, done)

        if done:
            break

if args.gif:
    print("Saving gif... ", end="")
    write_gif(numpy.array(frames), args.gif+".gif", fps=1/args.pause)
    print("Done.")
