
# algo means algorithm to train
algo=TeCLE

:<<'END'
**available environment list**
- MiniGrid-Empty-8x8-v0
- MiniGrid-Empty-16x16-v0
- MiniGrid-DoorKey-8x8-v0
- MiniGrid-DoorKey-16x16-v0
- MiniGrid-KeyCorridorS3R3-v0 
- MiniGrid-Unlock-v0
- MiniGrid-LavaCrossingS9N3-v0
- MiniGrid-LavaCrossingS11N5-v0
- MiniGrid-MultiRoom-N2-S4-v0 
END

# put your train environment below
envs=(
    MiniGrid-Empty-8x8-v0
      )

# log_interval means the frequency of logging.
log_interval=10

# save_interval means the frequency of save checkpoint.
save_interval=50

# procs means number of processor.
procs=16

# frames means the number of frame to train.
frames=5000000

# noisy_tv means to apply noisy TV  wrapper to environment(select 'True' or 'False')
noisy_tv=(False)

# noise_beta means beta of colored noise injected to latent space.
# (choice beta={-1.0, 0.0, 0.5, 1.0, 2.0})
noise_beta=(
    -1.0
    )

# seed means environment seed.
seed=1

for noisy in ${noisy_tv[@]}; do
    for beta in ${noise_beta[@]}; do
        for env in ${envs[@]}; do
        
            model=${algo}_${env}_${frames}_noisy_tv_${noisy}_noise_beta_${beta}_seed_${seed}
            
            python3 -m scripts.train --algo $algo \
                                    --env $env \
                                    --log-interval $log_interval \
                                    --save-interval $save_interval \
                                    --procs $procs \
                                    --frames $frames \
                                    --model $model \
                                    --heatmap \
                                    --noisy_tv $noisy \
                                    --noise_beta $beta \
                                    --seed $seed \

        done
    done
done