import os
import logging
import datetime
import pathlib

import json

PROJECT_PATH = pathlib.Path(__file__).parent.parent.parent.resolve()
with open(PROJECT_PATH / 'folder_path_settings.json') as json_file:
    SETTINGS = json.load(json_file)
ROOT_DIR = pathlib.Path(SETTINGS["ROOT_DIR"])
LOGDIR = ROOT_DIR / "logs"
assert os.path.exists(ROOT_DIR)
if not os.path.exists(LOGDIR):
    LOGDIR.mkdir(exist_ok=False, parents=False)

LOGGER_ROOT = "path_learning.experiment"


def create_base_logger(logdir: pathlib.Path) -> logging.Logger:
    logger = get_logger("")
    logger.setLevel(logging.INFO)
    fh = logging.FileHandler(logdir / "run.log")
    fmt_str = '{"time": "%(asctime)s", "logger_name": %(name)s", "level":"%(levelname)s", "message": "%(message)s"}'
    formatter = logging.Formatter(fmt_str)
    fh.setFormatter(formatter)
    fh.setLevel(logging.DEBUG)
    logger.addHandler(fh)
    return logger


def get_logger(name: str = "") -> logging.Logger:
    logger_name = LOGGER_ROOT
    if len(name) != 0:
        logger_name += f".{name}"
    return logging.getLogger(logger_name)


def get_timestring():
    return datetime.datetime.now().strftime("%Y-%m-%d-%H-%M-%S")


def init_logging(level=logging.INFO):
    logging.basicConfig(level=level)


