from rl_algos.multi_agent.MAAC.agent import Agent

from utils.misc import get_dataset, wandb_init


def maac(config_dict):
    env = config_dict['env']

    if config_dict['offline']:
        dataset = get_dataset(env,config_dict)
    else:
        dataset = None

    config_dict['is_continuous'] = False

    lr_info = {'critic_lr':1e-4,
               'actor_lr':1e-3,
               'tau':5e-3,
               'n_steps':3,
               }

    config_dict.update(lr_info)

    config_dict['algo_name']='maac'

    config_dict['softmax_tau'] = 10

    if config_dict['use_wandb']:
        wandb_init(config_dict)


    obs_dims = env.observation_space.shape[0]

    agent = Agent(obs_dims=obs_dims,
                  action_dims=env.action_space.shape[0],
                  dataset=dataset,
                  **config_dict
                  )


    if config_dict['offline']:
        agent.train_offline(config_dict)
    else:
        agent.train_online(config_dict)

