% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{ANM_MLP}
\alias{ANM_MLP}
\title{Additive Noise Model using MLP regression.}
\usage{
ANM_MLP(x, y, epochs = 20L, D_in = 1L, D_H1 = 7L, D_H2 = 5L,
  D_out = 1L, batch_size = 128L, cuda = FALSE, seed = 0L,
  log_interval = 10L, learning_rate = 0.01, verbose = FALSE, ...)
}
\arguments{
\item{x}{The observation of the cause.}

\item{y}{The observation of the effect.}

\item{epochs}{The training epochs}

\item{D_in}{Dimension of input}

\item{D_H1}{Dimension of hidden layer 1}

\item{D_H2}{Dimension of hidden layer 2}

\item{D_out}{Dimension of output}

\item{batch_size}{Batch size}

\item{cuda}{Use GPU}

\item{seed}{Random Seed}

\item{log_interval}{The option of verbose that output the training detail at each interval.}

\item{learning_rate}{The learning rate.}

\item{verbose}{print the output}

\item{...}{Other parameters}
}
\description{
Additive noise model using the MLP regression.
}
\examples{
set.seed(0)
x=rnorm(1000)
y=exp(x)+rnorm(1000)
result=ANM_MLP(x,y)
if(result$HSIC_xy<result$HSIC_yx){
 print("X->Y")
}else{
 print("Y->X")
}
}
