% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{ANM_XGB}
\alias{ANM_XGB}
\title{Additive noise model using XGBoost regression.}
\usage{
ANM_XGB(x, y, booster = "gbtree", nrounds = 30, gamma = 0,
  nthread = 1, ...)
}
\arguments{
\item{x}{The observation of the cause.}

\item{y}{The observation of the effect.}

\item{booster}{The regression function, "gbtree" or "gblinear"}

\item{nrounds}{The number of tree}

\item{gamma}{The gamma parameter that controls the pruning process. The higher gamma the less overfitting.}

\item{nthread}{The number of CPU.}

\item{...}{Other parameters see ?xgboost}
}
\description{
Additive noise model using the XGBoost regression.
}
\examples{
set.seed(0)
x=rnorm(1000)
y=exp(x)+rnorm(1000)
result=ANM_XGB(x,y)
if(result$HSIC_xy<result$HSIC_yx){
 print("X->Y")
}else{
 print("Y->X")
}

}
