% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{CANM}
\alias{CANM}
\title{CANM with auto search the number latent variables.}
\usage{
CANM(X, Y, N = NULL, epochs = 50L, batch_size = 128L,
  prior_sdy = 0.5, minN = 1L, maxN = 5L, seed = 0L,
  update_sdy = TRUE, ...)
}
\arguments{
\item{X}{The cause variable.}

\item{Y}{The effect variable.}

\item{N}{The number of hidden intermediated variables. If N=NULL, it will perform an auto search from minN to maxN.}

\item{epochs}{The training epochs}

\item{batch_size}{The batch size}

\item{prior_sdy}{The initialization of the standard error at noise distribution.}

\item{minN}{The minimum N of the searching progress. It will search N from minN to maxN.}

\item{maxN}{The maximum N of the searching progress. It will search N from minN to maxN.}

\item{seed}{The random seed}

\item{update_sdy}{Whether update the noise distribution by using gradient decent.}

\item{...}{Other parameters for CANM, see CANM.py for more details.}
}
\value{
The likelihood of the model.
}
\description{
Fit the Latent variable with ANM.
}
\examples{
set.seed(0)
data=CANM_data(depth=2,sample_size=5000)
lxy=CANM(data[,1],data[,2])
lyx=CANM(data[,2],data[,1])
if(max(lxy$train_score)>max(lyx$train_score)){
 print("X->Y")
}else{
 print("Y->X")
}

}
