% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{IGCI}
\alias{IGCI}
\title{Information-geometric approach to inferring causal directions.}
\usage{
IGCI(x, y, refMeasure, estimator)
}
\arguments{
\item{x}{The observation of the cause.}

\item{y}{The observation of the effect.}

\item{refMeasure}{reference measure to use: 1: uniform 2: Gaussian}

\item{estimator}{estimator to use:1: entropy (eq. (12) in [1]),
 2: integral approximation (eq. (13) in [1]).
3: new integral approximation (eq. (22) in [2]) that should
    deal better with repeated values}
}
\value{
f < 0:       the method prefers the causal direction x -> y \cr
         f > 0:       the method prefers the causal direction y -> x
}
\description{
This is the implementation of the IGCI method for causal discovery.
}
\examples{
set.seed(0)
x=rnorm(100)
y=exp(x)
f=IGCI(x,y,refMeasure=2,estimator=1)
if(f<0){
 print("X->Y")
}else{
 print("Y->X")
}

}
\references{
Janzing, Dominik, et al. "Information-geometric approach to inferring causal directions." Artificial Intelligence 182 (2012): 1-31.
}
