---
name: Bug report
about: Create a report to help us improve
title: ''
labels: 'bug'
assignees: ''

---

<!--
Please fill this template entirely and do not erase any of it.
We reserve the right to close without a response bug reports which are incomplete.
-->

## Checklist

<!-- To check an item on the list replace [ ] with [x]. -->

- [ ] I have verified that the issue exists against the `main` branch.
- [ ] I have read the relevant section in the [contribution guide](https://github.com/py-why/dodiscover/blob/main/CONTRIBUTING.md#bug-reports-and-feature-requests) on reporting bugs.
- [ ] I have checked the [issues list](https://github.com/py-why/dodiscover/issues) for similar or identical bug reports.
- [ ] I have checked the [pull requests list](https://github.com/py-why/dodiscover/pulls) for existing proposed fixes.
- [ ] I have checked the [CHANGELOG](https://github.com/py-why/dodiscover/blob/main/CHANGELOG.md) and the [commit log](https://github.com/py-why/dodiscover/commits/main) to find out if the bug was already fixed in the main branch.
- [ ] I have included in the "Description" section below a traceback from any exceptions related to this bug.
- [ ] I have included in the "Related issues or possible duplicates" section beloew all related issues and possible duplicate issues (If there are none, check this box anyway).
- [ ] I have included in the "Environment" section below the name of the operating system and Python version that I was using when I discovered this bug.
- [ ] I have included in the "Environment" section below the output of `pip freeze`.
- [ ] I have included in the "Steps to reproduce" section below a minimally reproducible example.


## Description

<!-- Please provide a clear and concise description of what the bug is here. -->

<details>
<summary><b>Python traceback:</b></summary>
<p>

<!-- Paste the traceback from any exception (if there was one) in between the next two lines below -->
```
```

</p>
</details>


## Related issues or possible duplicates

- None


## Environment

<!-- Provide the name of operating system below (e.g. OS X, Linux) -->
OS:

<!-- Provide the Python version you were using (e.g. 3.7.1) -->
Python version:

<details>
<summary><b>Output of <code>pip freeze</code>:</b></summary>
<p>

<!-- Paste the output of `pip freeze` in between the next two lines below -->
```
```

</p>
</details>


## Steps to reproduce


<details>
<summary><b>Example source:</b></summary>
<p>

<!-- Add a fully runnable example in between the next two lines below that will reproduce the bug -->
```
```

</p>
</details>
