
import numpy
import pandas
from scipy.interpolate import UnivariateSpline

def CANM_data(depth=1, sample_size=5000, ratio=1, k=3, changepoints=6, sd=1, noisedist="normal", **kwargs):
    # Generate mixture Gaussian distribution components
    p = numpy.abs(numpy.random.normal(size=k))
    p = p / numpy.sum(p)
    components = numpy.random.choice(numpy.arange(1, k + 1), size=sample_size, p=p)
    mus = numpy.random.normal(size=k)
    sds = ((2 * numpy.random.normal(size=k) + 1) ** 2) / 5
    x = numpy.random.normal(loc=mus[components - 1], scale=sds[components - 1], size=sample_size)

    data = pandas.DataFrame({'x': x})

    def get_noise_distribution(noisedist):
        if noisedist == "normal":
            return numpy.random.normal
        elif noisedist == "uniform":
            return numpy.random.uniform
        else:
            raise ValueError(f"Unsupported noise distribution: {noisedist}")

    distf = get_noise_distribution(noisedist)

    if depth == 0:
        f = UnivariateSpline(
            numpy.linspace(numpy.min(data['x']), numpy.max(data['x']), changepoints),
            numpy.random.normal(scale=sd, size=changepoints),
            s=0
        )
        data['y'] = f(data['x']) + distf(size=sample_size, **kwargs) * ratio
    else:
        for d in range(depth):
            f = UnivariateSpline(
                numpy.linspace(numpy.min(data.iloc[:, d]), numpy.max(data.iloc[:, d]), changepoints),
                numpy.random.normal(scale=sd, size=changepoints),
                s=0
            )

            if noisedist == "mixgauss":
                p = numpy.abs(numpy.random.normal(size=k))
                p = p / numpy.sum(p)
                components = numpy.random.choice(numpy.arange(1, k + 1), size=sample_size, p=p)
                mus = numpy.random.normal(size=k)
                sds = ((2 * numpy.random.normal(size=k) + 1) ** 2) / 5
                noise = numpy.random.normal(loc=mus[components - 1], scale=sds[components - 1], size=sample_size)
                noise = noise - numpy.mean(noise)
                data[f'y_{d + 1}'] = f(data.iloc[:, d]) + noise * ratio

            elif noisedist == "supgauss":
                eps = numpy.random.normal(size=sample_size, **kwargs)
                data[f'y_{d + 1}'] = f(data.iloc[:, d]) + numpy.sign(eps) * (eps ** 2) * ratio

            elif noisedist == "uniform":
                data[f'y_{d + 1}'] = f(data.iloc[:, d]) + distf(-1, 1, size=sample_size) * ratio

            else:
                data[f'y_{d + 1}'] = f(data.iloc[:, d]) + distf(size=sample_size, **kwargs) * ratio

        f = UnivariateSpline(
            numpy.linspace(numpy.min(data.iloc[:, depth]), numpy.max(data.iloc[:, depth]), changepoints),
            numpy.random.normal(scale=sd, size=changepoints),
            s=0
        )

        if noisedist == "mixgauss":
            p = numpy.abs(numpy.random.normal(size=k))
            p = p / numpy.sum(p)
            components = numpy.random.choice(numpy.arange(1, k + 1), size=sample_size, p=p)
            mus = numpy.random.normal(size=k)
            sds = ((2 * numpy.random.normal(size=k) + 1) ** 2) / 5
            noise = numpy.random.normal(loc=mus[components - 1], scale=sds[components - 1], size=sample_size)
            noise = noise - numpy.mean(noise)
            data[f'y_{depth + 1}'] = f(data.iloc[:, depth]) + noise * ratio
        else:
            data[f'y_{depth + 1}'] = f(data.iloc[:, depth]) + distf(size=sample_size, **kwargs) * ratio

        data = data.iloc[:, [0, depth + 1]]

    return data.to_numpy()