import numpy as np
import numpy
import matplotlib.pyplot as plt

# Set random seed for reproducibility
rng = np.random.default_rng()

# Define network parameters
num_parents = 1  # Number of parent nodes
num_hidden = 10  # Number of hidden layer units

# Initialize random weights and biases
weights_in = rng.uniform(-5, 5, (num_parents, num_hidden))  # (num_parents, num_hidden)
bias_hidden = rng.uniform(-5, 5, num_hidden)  # (num_hidden,)
weights_out = rng.uniform(-5, 5, num_hidden)  # (num_hidden,)

# Define the transformation function

alpha = 5


def transform(parent_data: numpy.ndarray) -> numpy.ndarray:
    return numpy.maximum(0, parent_data) + alpha * numpy.minimum(0, parent_data)


# Generate sample input data
parent_data = np.linspace(-5, 5, num=100)

# Apply transformation
output_data = transform(parent_data.reshape(-1, 1))

# Plot the function output against one of the input dimensions
plt.figure(figsize=(8, 6))
plt.plot(parent_data, output_data, alpha=0.6, label="Transformed Output")
plt.xlabel("First Parent Node Input")
plt.ylabel("Transformed Output")
plt.title("PreLu Transformation Output")
plt.legend()
plt.grid(True)
plt.show()
