#This file lays out a bunch of test DAGs under different models. Data is standardized after generation.
import warnings
import time
warnings.filterwarnings("ignore")
import numpy as np

def standardize_vectors(*vectors):
    '''standardizes input vectors'''
    standardized_vectors = []
    for vector in vectors:
        mean = np.mean(vector)
        std = np.std(vector)
        if std == 0:
            raise ValueError(f"Cannot standardize vector with zero standard deviation: {vector}")
        standardized_vector = (vector - mean) / std
        standardized_vectors.append(standardized_vector)
    return standardized_vectors

#3-Node DAG Markov Equivalence Classes
def mediator_lin_additive(n=1000, a=1, b=1, c=1, noise="gaussian"):
    '''Linear, z mediates x and y, x->y. Noise options: "gaussian","gamma"'''
    if noise == "gaussian":
        #DAG Structure
        x = np.random.normal(0, 1, n)
        z = a*x**2 + np.random.normal(0, 1, n)
        y = b*x**2 + c*z**2 + np.random.normal(0, 1, n)
    elif noise == "gamma":
        #DAG Structure
        x = np.random.gamma(shape=2, scale=1, size=n)  # shape=2 gives reasonable skewness
        z = a*x**2 + np.random.gamma(shape=2, scale=1, size=n)
        y = b*x**2 + c*z**2 + np.random.gamma(shape=2, scale=1, size=n)
    else:   
        raise ValueError(f"Unsupported noise type: {noise}")
    data = np.column_stack(standardize_vectors(x,y))
    return data


