% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{CANM_data}
\alias{CANM_data}
\title{Synthetic data for CANM.}
\usage{
CANM_data(depth = 1, sample_size = 5000, ratio = 1, k = 3,
  changepoints = 6, sd = 1, noisedist = "rnorm", ...)
}
\arguments{
\item{depth}{The depth of the CANM (the number of the latent intermediated variables).}

\item{sample_size}{The number of samples.}

\item{ratio}{The ratio of noise.}

\item{k}{The number of components in the mixture Gaussian distribution of X.}

\item{changepoints}{The mapping function at each layer are generated from a cubic spline interpolation using a 6-dimensional grid with respect to 6 random generated points as knots for the interpolation; Here the changepoint control the number of knots as controlling the nonlinearity of the mapping function.}

\item{sd}{The standard error of the random generative knots.}

\item{noisedist}{The noise distribution at each layer.}

\item{...}{Additional parameters for the specify noise distribution.}
}
\value{
Data
}
\description{
Amore general version for Generating data from transitive ANM.
}
\examples{
set.seed(0)
data=CANM_data(depth=2,ratio=0.2)
plot(data[,1],data[,2])


}
