# BiDD - Bivariate Denoising Diffusion for causal discovery

This is the code to reproduce the experimental results for our paper:

[When Additive Noise Meets Unobserved Mediators: Bivariate Denoising for Causal Discovery]()

## Installation

For our experiments, we used `python3.11`. We recommend setting up a conda environment:
```
conda create -n discovery311 python=3.11; conda activate discovery311; conda install pytorch torchvision torchaudio -c pytorch-nightly
```

Then installing the requirements with:
```bash
pip install -r requirements.txt
```

To install additional requirements for baselines and `NPEET`, you can run
```bash
bash install_requirements.txt
```

## Running the experiments

We provide three different scripts to run the experiments
`run_diffusion.py` runs BiDD.
`run_CANM.py` runs CANM.
`run_baselines.py` runs the baselines.

To run the experiments for the different mechanism tables, run
```run_experiments_mechanism_table.py```

To run the experiments for the depth and sample size tables, run
```run_experiments_depth_tanh_uniform.py``` and
```run_experiments_sample_size_tanh_uniform.py```

To run the experiments for the Tübingen cause-effect pair, run
```run_experiments_tuebingen_3000.py```.

## Analyzing the simulation data
The experiment scripts generate data in the results folder, which can be analysed using Jupyter notebook `.ipynb` files.

They are named

```data_analysis_diffusion_mechanism_table.ipynb```
```data_analysis_diffusion_depth_table.ipynb```
```data_analysis_diffusion_sample_size_table.ipynb```
```data_analysis_tuebingen.ipynb```.