# check_codec.py
import numpy as np
import xicorpy

# --- rpy2 setup -------------------------------------------------------------
import rpy2.robjects as ro
from rpy2.robjects import numpy2ri

numpy2ri.activate()  # automatic NumPy <-> R conversion
ro.r("suppressPackageStartupMessages(library(FOCI))")
r_codec = ro.r["codec"]

# ---------------------------------------------------------------------------
# 1) reproducible synthetic data (no conditioning)
rng = np.random.default_rng(seed=41)
n, q = 1000, 1  # 1000 samples, Z has 2 columns

Y = rng.standard_normal(n)  # (n,)
Z = rng.standard_normal(
    n,
)  # (n, 2)

# 2) Python score
py_score = xicorpy.compute_conditional_dependence(Y, Z)  # unconditional ⇒ omit X
py_score_2 = xicorpy.compute_conditional_dependence(Z, Y)  # unconditional ⇒ omit X

# 3) R score
r_score = np.array(r_codec(Y, Z))  # X=NULL default
r_score_2 = np.array(r_codec(Z, Y))  # X=NULL default

# 4) Compare
print(f"Python  (xicorpy) : {py_score}")
print(f"Python  (xicorpy) : {py_score_2}")
print(f"R       (FOCI)    : {r_score}")
print(f"R       (FOCI)    : {r_score_2}")
print(
    "Agreement (rtol=1e-8, atol=1e-10):",
    np.allclose(py_score, r_score, rtol=1e-8, atol=1e-10),
)
