import pandas as pd
import seaborn as sns
import matplotlib.pyplot as plt

plt.rcParams["pdf.fonttype"] = 42
plt.rcParams["ps.fonttype"] = 42

data = pd.read_csv('summary.csv')

y_label = "QD-Score"

plt.figure(figsize = (12,12))

# Color mapping for algorithms
palette ={
    "CMA-MEGA": "C0", 
    "CMA-MEGA (Adam)": "C1", 
    "OMG-MEGA": "C2", 
    "OG-MAP-Elites": "C3",
    "OG-MAP-Elites (line)": "C4",
    "CMA-ME": "C5",
    "MAP-Elites": "C6",
    "MAP-Elites (line)": "C7",
}

sns.set(font_scale=4)
with sns.axes_style("white"):
    sns.set_style("white",{'font.family':'serif','font.serif':'Palatino'})
    sns.set_palette("colorblind")
    
    # Plot the responses for different events and regions
    sns_plot = sns.lineplot(x="Iteration", 
                            y=y_label, 
                            linewidth=3.0,
                            hue="Algorithm",
                            data=data, 
                            legend=False, 
                            palette=palette,
                           )
    plt.xticks([0, 5000, 10000])
    plt.yticks([0, 80])
    plt.xlabel("Iterations")
    plt.ylabel(y_label)
    #sns_plot.yaxis.set_label_coords(0.5,0.0)
    #sns_plot.xaxis.set_label_coords(0.5,-0.15)

    legend = plt.legend(loc='center', frameon=False, prop={'size': 30})
    legend.set_bbox_to_anchor((0.63, 0.47))
    for line in legend.get_lines():
        line.set_linewidth(4.0)
    
    frame = legend.get_frame()
    frame.set_facecolor('white')
    plt.tight_layout()
    #plt.show()
    sns_plot.figure.savefig("qd_score.pdf")
