/* Defines the natural numbers, simple functions on them, and proofs by induction. */

import "prelude.p".

nat : type.
z : nat.
s : [nat -> nat].

+ : [nat -> nat -> nat].
* : [nat -> nat -> nat].
pow : [nat -> nat -> nat].

prime : [nat -> prop].

lemma zero_add : [('n : nat) -> (= (+ z 'n) 'n)] { }
lemma succ_add : [('n : nat) -> ('m : nat) -> (= (+ (s 'n) 'm) (s (+ 'n 'm)))] { }

theorem add_comm : [('n : nat) -> ('m : nat) -> (= (+ 'n 'm) (+ 'm 'n))] { }
theorem add_assoc : [('a : nat) -> ('b : nat) -> ('c : nat) -> (= (+ (+ 'a 'b) 'c) (+ 'a (+ 'b 'c)))] { }

theorem mul_comm : [('n : nat) -> ('m : nat) -> (= (* 'n 'm) (* 'm 'n))] { }
theorem mul_assoc : [('a : nat) -> ('b : nat) -> ('c : nat) -> (= (* (* 'a 'b) 'c) (* 'a (* 'b 'c)))] { }
