from rdkit.Chem import Descriptors, rdmolops, MolFromSmiles
import networkx as nx

from conditional_generation import sascorer


def compute_penalized_logP(smiles):
    mol = MolFromSmiles(smiles)
    
    current_log_P_value = Descriptors.MolLogP(mol)
    
    current_SA_score = -sascorer.calculateScore(mol)
    
    cycle_list = nx.cycle_basis(nx.Graph(rdmolops.GetAdjacencyMatrix(mol)))
    if len(cycle_list) == 0:
        cycle_length = 0
    else:
        cycle_length = max([ len(j) for j in cycle_list ])
    if cycle_length <= 6:
        cycle_length = 0
    else:
        cycle_length = cycle_length - 6
    current_cycle_score = -cycle_length
    
    score = current_log_P_value + current_SA_score + current_cycle_score
    return score
