import rdkit.Chem as Chem
from rdkit import DataStructs
from rdkit.Chem import AllChem


def get_tanimoto_similarity(smiles1, smiles2):
    mol1 = Chem.MolFromSmiles(smiles1)
    fp1 = AllChem.GetMorganFingerprint(mol1, 2)

    mol2 = Chem.MolFromSmiles(smiles2)
    fp2 = AllChem.GetMorganFingerprint(mol2, 2)

    sim = DataStructs.TanimotoSimilarity(fp1, fp2) 

    return sim
