# GRIN: Repetition-Invariant Polymer Representation Learning

## Overview

This script, `rungrin.py`, is designed to run experiments for the GRIN (Graph Representation for Repetition-Invariant kNowledge) method. It facilitates training and testing Graph Neural Network (GNN) models for polymer representation learning, with a focus on handling repetitions in polymer structures.

The script allows for configurable model architectures, training parameters, and experiment setups through command-line arguments. It also supports loading optimized hyperparameters from a CSV file for specific model types and tasks.

## Prerequisites

All dependencies specified in the requirements.txt file. The packages can be installed by
```
pip install -r requirements.txt
```

## Configuration

The script can be configured via command-line arguments and an optional hyperparameter summary file.

### Command-Line Arguments

The following arguments can be used to customize the execution of `rungrin.py`:

**General:**
-   `--by_default`: `store_true`, default: `False`. If set, the script will attempt to load hyperparameters from `hyperparameters_summary.csv` based on `--model_type` and `--task_name`.

**Experiment Setup:**
-   `--train_rep`: `list`, default: `[1]`. Specifies the training repetition(s). Example: `[1]` for a single model, `[1,3]` for models with 1 and 3 repetitions.
-   `--test_rep`: `list`, default: `[1,5,10,60]`. Specifies the testing repetition(s). Example: `[1,5,10,60]`.
-   `--task_name`: `str`, default: `mt`. The name of the task (e.g., 'mt' for multi-task). Used with `--by_default` to look up hyperparameters.
-   `--polymer_type`: `str`, default: `homopolymer`. Type of polymer being processed (e.g., 'homopolymer', 'copolymer').


### Hyperparameter Configuration File (`hyperparameters_summary.csv`)

If the `--by_default` flag is used, the script attempts to load hyperparameters from a file named `hyperparameters_summary.csv` located in the same directory as the script. This CSV file should contain optimal settings for different model types and tasks.

The expected columns in `hyperparameters_summary.csv` are:
-   `model_type`: Matches the `--model_type` argument.
-   `task`: Matches the `--task_name` argument.
-   `num_layer`: Overrides `--num_layer`.
-   `lr`: Overrides `--lr`.
-   `polymer_type`: Overrides `--polymer_type`.

If the file is not found, or if a matching entry for the given `model_type` and `task_name` is not found, a warning will be printed, and the script will use the default values or those provided via command-line arguments.

## Usage

To run the script, navigate to its directory and execute it with Python, providing any desired arguments.

**Basic execution with default parameters:**
```bash
python rungrin.py
```

**Example using pre-defined hyperparameters from CSV for GCN model and 'mt' task:**
```bash
python rungrin.py --model_type gcn --task_name mt --by_default
```


The script will then initialize and run the `MainGRIN` process with the specified (or default) configuration.
python rungrin