import gym

import gym
import random
import numpy as np


class RandomInitWrapper(gym.Wrapper):

    def __init__(
        self,
        env,
        task="",
        max_episode_steps=1000,
    ):
        super().__init__(env)
        self.task = task
        self._max_episode_steps = max_episode_steps
        self._elapsed_steps = 0
        self._view = self.env._view

    def reset(self, **kwargs):
        obs = self.env.reset(**kwargs)

        self._world = self.env._world
        self._player = self.env._player

        self._elapsed_steps = 0
        self._randomize_inventory()
        return obs

    def step(self, action):
        self._elapsed_steps += 1
        obs, reward, done, info = self.env.step(action)
        self._step = self.env._step
        self._unlocked = self.env._unlocked

        if self._elapsed_steps >= self._max_episode_steps:
            done = True
        return obs, reward, done, info

    def _randomize_inventory(self):
        inventory = {}

        inventory["health"] = random.randint(6, 10)
        inventory["food"] = random.randint(6, 10)
        inventory["drink"] = random.randint(6, 10)
        inventory["energy"] = random.randint(6, 10)

        inventory["sapling"] = random.randint(0, 3)
        inventory["wood"] = random.randint(5, 9)

        # pickaxe progression
        has_wood_pickaxe = random.random() < 0.9
        inventory["wood_pickaxe"] = int(has_wood_pickaxe)

        if has_wood_pickaxe:
            inventory["stone"] = random.randint(5, 7)
            has_stone_pickaxe = random.random() < 0.8
            inventory["stone_pickaxe"] = int(has_stone_pickaxe)
            inventory["coal"] = random.randint(2, 5)

            if has_stone_pickaxe:
                inventory["iron"] = random.randint(2, 5)
                has_iron_pickaxe = random.random() < 0.7
                inventory["iron_pickaxe"] = int(has_iron_pickaxe)

                if inventory["iron_pickaxe"]:
                    inventory["diamond"] = random.randint(0, 1)
                else:
                    inventory["diamond"] = 0
            else:
                inventory["coal"] = 0
                inventory["iron"] = 0
                inventory["iron_pickaxe"] = 0
                inventory["diamond"] = 0
        else:
            inventory["stone"] = 0
            inventory["stone_pickaxe"] = 0
            inventory["coal"] = 0
            inventory["iron"] = 0
            inventory["iron_pickaxe"] = 0
            inventory["diamond"] = 0

        # sword is similar to pickaxe
        inventory["wood_sword"] = int(random.random() < 0.9)
        inventory["stone_sword"] = (
            int(random.random() < 0.8) if inventory["wood_pickaxe"] else 0
        )
        inventory["iron_sword"] = (
            int(random.random() < 0.7) if inventory["stone_pickaxe"] else 0
        )

        self._player.inventory = inventory

    def render(self, size=None):
        return self.env.render(size)
